<?php
// Database connection test
require_once '../config/database.php';

try {
    $database = new Database();
    $db = $database->getConnection();

    if ($db) {
        echo "✓ Database connection successful<br>";

        // Test if tables exist
        $tables = ['users', 'withdrawal_requests', 'user_sessions', 'system_settings'];

        foreach ($tables as $table) {
            try {
                $stmt = $db->query("SELECT COUNT(*) FROM $table");
                $count = $stmt->fetchColumn();
                echo "✓ Table '$table' exists with $count records<br>";
            } catch (PDOException $e) {
                echo "✗ Table '$table' does not exist or has issues: " . $e->getMessage() . "<br>";
            }
        }
    } else {
        echo "✗ Database connection failed<br>";
    }
} catch (Exception $e) {
    echo "✗ Error: " . $e->getMessage() . "<br>";
}
