<?php
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type');

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    exit(0);
}

require_once '../config/database.php';

try {
    $database = new Database();
    $db = $database->getConnection();

    // Get all system settings
    $query = "SELECT setting_key, setting_value FROM system_settings";
    $stmt = $db->prepare($query);
    $stmt->execute();

    $settings = [];
    while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
        $key = $row['setting_key'];
        $value = $row['setting_value'];

        // Handle different data types based on setting name
        if (strpos($key, '_id') !== false || strpos($key, 'admob_') === 0) {
            $settings[$key] = $value; // Keep as string for Ad IDs
        } elseif ($key === 'withdrawals_enabled') {
            $settings[$key] = ($value === '1' || $value === 'true'); // Convert to boolean
        } else {
            $settings[$key] = (float)$value; // Convert to float for numeric settings
        }
    }    // Set default values if settings don't exist
    $defaultSettings = [
        // Earning and withdrawal settings
        'earning_rate_per_minute' => 0.10,
        'minimum_withdrawal_amount' => 5.00,
        'maximum_withdrawal_amount' => 1000.00,
        'withdrawal_fee_percentage' => 2.5,
        'daily_earning_limit' => 50.00,
        'admob_user_share_percentage' => 70.0,
        'race_completion_bonus_percentage' => 50.0,
        'withdrawals_enabled' => true,

        // Android AdMob Ad Unit IDs
        'admob_android_banner_id' => 'ca-app-pub-3940256099942544/6300978111', // Test ID
        'admob_android_interstitial_id' => 'ca-app-pub-3940256099942544/1033173712', // Test ID
        'admob_android_rewarded_id' => 'ca-app-pub-3940256099942544/5224354917', // Test ID

        // iOS AdMob Ad Unit IDs
        'admob_ios_banner_id' => 'ca-app-pub-3940256099942544/2934735716', // Test ID
        'admob_ios_interstitial_id' => 'ca-app-pub-3940256099942544/4411468910', // Test ID
        'admob_ios_rewarded_id' => 'ca-app-pub-3940256099942544/1712485313' // Test ID
    ];

    foreach ($defaultSettings as $key => $defaultValue) {
        if (!isset($settings[$key])) {
            $settings[$key] = $defaultValue;
        }
    }

    echo json_encode([
        'success' => true,
        'message' => 'Settings retrieved successfully',
        'settings' => $settings
    ]);
} catch (Exception $e) {
    error_log("Get Settings Error: " . $e->getMessage());
    echo json_encode([
        'success' => false,
        'message' => 'Failed to retrieve settings: ' . $e->getMessage()
    ]);
}
