<?php
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST');
header('Access-Control-Allow-Headers: Content-Type');

require_once '../config/database.php';
require_once '../models/UserSession.php';

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode(['success' => false, 'message' => 'Method not allowed']);
    exit;
}

$database = new Database();
$db = $database->getConnection();

$userSession = new UserSession($db);

$data = json_decode(file_get_contents("php://input"));

if (!$data || !isset($data->user_id) || !isset($data->ad_type) || !isset($data->revenue)) {
    http_response_code(400);
    echo json_encode(['success' => false, 'message' => 'User ID, ad type, and revenue are required']);
    exit;
}

$ad_unit_id = isset($data->ad_unit_id) ? $data->ad_unit_id : null;

$result = $userSession->recordAdMobRevenue(
    $data->user_id,
    $data->ad_type,
    $data->revenue,
    $ad_unit_id
);

if ($result) {
    echo json_encode([
        'success' => true,
        'message' => 'AdMob revenue recorded successfully'
    ]);
} else {
    http_response_code(500);
    echo json_encode(['success' => false, 'message' => 'Failed to record AdMob revenue']);
}
