<?php
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST');

require_once '../../config/database.php';
require_once '../../models/WithdrawalRequest.php';

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode(['success' => false, 'message' => 'Method not allowed']);
    exit;
}

$database = new Database();
$db = $database->getConnection();

try {
    $withdrawal_id = $_POST['withdrawal_id'];
    $new_status = $_POST['status'];
    $admin_notes = $_POST['admin_notes'] ?? '';
    $admin_id = 1; // TODO: Get from session

    // Get withdrawal request details
    $query = "SELECT * FROM withdrawal_requests WHERE id = :id";
    $stmt = $db->prepare($query);
    $stmt->bindParam(':id', $withdrawal_id);
    $stmt->execute();
    $withdrawal = $stmt->fetch(PDO::FETCH_ASSOC);

    if (!$withdrawal) {
        throw new Exception('Withdrawal request not found');
    }

    $withdrawalRequest = new WithdrawalRequest($db);
    $withdrawalRequest->id = $withdrawal_id;
    $withdrawalRequest->user_id = $withdrawal['user_id'];
    $withdrawalRequest->amount = $withdrawal['amount'];

    if ($withdrawalRequest->updateStatus($new_status, $admin_id, $admin_notes)) {
        // Log the action
        $logQuery = "INSERT INTO activity_logs (admin_id, action, details) 
                     VALUES (:admin_id, :action, :details)";
        $stmt = $db->prepare($logQuery);
        $action = "Withdrawal " . $new_status;
        $details = "Updated withdrawal request #$withdrawal_id to $new_status";
        $stmt->bindParam(':admin_id', $admin_id);
        $stmt->bindParam(':action', $action);
        $stmt->bindParam(':details', $details);
        $stmt->execute();

        echo json_encode([
            'success' => true,
            'message' => 'Withdrawal request updated successfully'
        ]);
    } else {
        throw new Exception('Failed to update withdrawal request');
    }
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode([
        'success' => false,
        'message' => $e->getMessage()
    ]);
}
