-- Add AdMob Ad Unit ID settings to existing database
-- Run this script if you already have a database set up

INSERT IGNORE INTO system_settings (setting_key, setting_value, description) VALUES 
-- Update existing settings to new naming convention
('minimum_withdrawal_amount', '5.00', 'Minimum withdrawal amount'),
('maximum_withdrawal_amount', '1000.00', 'Maximum withdrawal amount per request'),
('admob_user_share_percentage', '70', 'Percentage of AdMob revenue shared with users'),
('race_completion_bonus_percentage', '50', 'Bonus percentage for completing races'),

-- AdMob Ad Unit IDs for Android (Test IDs by default)
('admob_android_banner_id', 'ca-app-pub-3940256099942544/6300978111', 'Android Banner Ad Unit ID'),
('admob_android_interstitial_id', 'ca-app-pub-3940256099942544/1033173712', 'Android Interstitial Ad Unit ID'),
('admob_android_rewarded_id', 'ca-app-pub-3940256099942544/5224354917', 'Android Rewarded Ad Unit ID'),

-- AdMob Ad Unit IDs for iOS (Test IDs by default)
('admob_ios_banner_id', 'ca-app-pub-3940256099942544/2934735716', 'iOS Banner Ad Unit ID'),
('admob_ios_interstitial_id', 'ca-app-pub-3940256099942544/4411468910', 'iOS Interstitial Ad Unit ID'),
('admob_ios_rewarded_id', 'ca-app-pub-3940256099942544/1712485313', 'iOS Rewarded Ad Unit ID');

-- Note: Replace the test Ad Unit IDs above with your actual AdMob Ad Unit IDs
-- Test IDs are safe to use during development but won't generate real revenue
