<?php

/**
 * Fierce Mobile Game API Setup Script
 * Run this script once to set up the database and initial configuration
 */


// Database configuration
$host = "anemal.site";
$username = "anemal_fierce";
$password = "1gmW&?&SLyg}";
$database = "anemal_fierce";

try {
    echo "<h1>Fierce Mobile Game API Setup</h1>";

    // Create database connection
    $pdo = new PDO("mysql:host=$host", $username, $password);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    echo "<p>✓ Connected to MySQL server</p>";

    // Create database
    $pdo->exec("CREATE DATABASE IF NOT EXISTS $database");
    echo "<p>✓ Database '$database' created/verified</p>";

    // Use the database
    $pdo->exec("USE $database");

    // Read and execute schema
    $schema = file_get_contents(__DIR__ . '/database/schema.sql');

    // Split queries and execute
    $queries = explode(';', $schema);
    foreach ($queries as $query) {
        $query = trim($query);
        if (!empty($query)) {
            $pdo->exec($query);
        }
    }

    echo "<p>✓ Database tables created successfully</p>";

    // Verify admin user exists
    $stmt = $pdo->prepare("SELECT COUNT(*) FROM admins WHERE username = 'admin'");
    $stmt->execute();
    $adminExists = $stmt->fetchColumn() > 0;

    if (!$adminExists) {
        $hashedPassword = password_hash('admin123', PASSWORD_DEFAULT);
        $stmt = $pdo->prepare("INSERT INTO admins (username, email, password_hash, role) VALUES (?, ?, ?, ?)");
        $stmt->execute(['admin', 'admin@fiercegame.com', $hashedPassword, 'super_admin']);
        echo "<p>✓ Admin user created</p>";
    } else {
        echo "<p>✓ Admin user already exists</p>";
    }

    // Check if config file exists and is writable
    $configFile = __DIR__ . '/config/database.php';
    if (is_writable($configFile)) {
        echo "<p>✓ Configuration file is writable</p>";
    } else {
        echo "<p style='color: orange;'>⚠ Configuration file may not be writable. Please check file permissions.</p>";
    }

    echo "<h2>Setup Complete!</h2>";
    echo "<p><strong>Admin Panel:</strong> <a href='admin/'>Access Admin Dashboard</a></p>";
    echo "<p><strong>Default Admin Credentials:</strong></p>";
    echo "<ul>";
    echo "<li>Username: admin</li>";
    echo "<li>Password: admin123</li>";
    echo "</ul>";

    echo "<h3>API Endpoints:</h3>";
    echo "<ul>";
    echo "<li>Authentication: <code>api/auth.php</code></li>";
    echo "<li>Start Session: <code>api/start_session.php</code></li>";
    echo "<li>End Session: <code>api/end_session.php</code></li>";
    echo "<li>Record AdMob: <code>api/record_admob.php</code></li>";
    echo "<li>Withdrawal: <code>api/withdrawal.php</code></li>";
    echo "</ul>";

    echo "<h3>Unity Integration:</h3>";
    echo "<p>Copy the Unity scripts from the <code>unity_scripts/</code> folder to your Unity project.</p>";
    echo "<p>Update the API base URL in <code>FierceGameAPI.cs</code> to match your server.</p>";

    echo "<h3>Next Steps:</h3>";
    echo "<ol>";
    echo "<li>Test the admin panel login</li>";
    echo "<li>Configure system settings in the admin panel</li>";
    echo "<li>Integrate the Unity scripts into your game</li>";
    echo "<li>Test API endpoints with your Unity game</li>";
    echo "</ol>";

    echo "<div style='background: #f0f8ff; padding: 10px; border: 1px solid #0066cc; margin: 20px 0;'>";
    echo "<strong>Security Note:</strong> ";
    echo "For production deployment, please update database credentials, ";
    echo "implement proper API authentication, and enable HTTPS.";
    echo "</div>";
} catch (PDOException $e) {
    echo "<p style='color: red;'>✗ Database Error: " . $e->getMessage() . "</p>";
    echo "<p>Please check your database configuration and try again.</p>";
} catch (Exception $e) {
    echo "<p style='color: red;'>✗ Setup Error: " . $e->getMessage() . "</p>";
}
?>

<!DOCTYPE html>
<html>

<head>
    <title>Fierce Mobile Game API Setup</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            max-width: 800px;
            margin: 0 auto;
            padding: 20px;
        }

        code {
            background: #f5f5f5;
            padding: 2px 4px;
            border-radius: 3px;
        }

        ul,
        ol {
            line-height: 1.6;
        }

        h1,
        h2,
        h3 {
            color: #333;
        }

        .success {
            color: green;
        }

        .warning {
            color: orange;
        }

        .error {
            color: red;
        }
    </style>
</head>

<body>
    <!-- Setup content is echoed above -->
</body>

</html>