<?php
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST');
header('Access-Control-Allow-Headers: Content-Type');

require_once '../config/database.php';
require_once '../models/UserSession.php';

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode(['success' => false, 'message' => 'Method not allowed']);
    exit;
}

$database = new Database();
$db = $database->getConnection();

$userSession = new UserSession($db);

$data = json_decode(file_get_contents("php://input"));

if (!$data || !isset($data->session_id)) {
    http_response_code(400);
    echo json_encode(['success' => false, 'message' => 'Session ID is required']);
    exit;
}

$race_completed = isset($data->race_completed) ? (bool)$data->race_completed : false;

$result = $userSession->endSession($data->session_id, $race_completed);

if ($result) {
    echo json_encode([
        'success' => true,
        'message' => 'Session ended successfully',
        'session_data' => $result
    ]);
} else {
    http_response_code(500);
    echo json_encode(['success' => false, 'message' => 'Failed to end session']);
}
