<?php
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST');
header('Access-Control-Allow-Headers: Content-Type');

require_once '../config/database.php';
require_once '../models/UserSession.php';

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode(['success' => false, 'message' => 'Method not allowed']);
    exit;
}

$database = new Database();
$db = $database->getConnection();

$userSession = new UserSession($db);

$data = json_decode(file_get_contents("php://input"));

if (!$data || !isset($data->user_id)) {
    http_response_code(400);
    echo json_encode(['success' => false, 'message' => 'User ID is required']);
    exit;
}

$session_id = $userSession->startSession($data->user_id);

if ($session_id) {
    echo json_encode([
        'success' => true,
        'message' => 'Session started successfully',
        'session_id' => $session_id
    ]);
} else {
    http_response_code(500);
    echo json_encode(['success' => false, 'message' => 'Failed to start session']);
}
