<?php
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, GET');
header('Access-Control-Allow-Headers: Content-Type');

require_once '../config/database.php';
require_once '../models/WithdrawalRequest.php';

$database = new Database();
$db = $database->getConnection();

$withdrawalRequest = new WithdrawalRequest($db);

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Create new withdrawal request
    $data = json_decode(file_get_contents("php://input"));

    if (!$data || !isset($data->user_id) || !isset($data->amount) || !isset($data->payment_type) || !isset($data->payment_address)) {
        http_response_code(400);
        echo json_encode(['success' => false, 'message' => 'All fields are required']);
        exit;
    }

    // Check if withdrawals are enabled
    $settings_check = $db->prepare("SELECT setting_value FROM system_settings WHERE setting_key = 'withdrawals_enabled'");
    $settings_check->execute();
    $withdrawals_setting = $settings_check->fetch(PDO::FETCH_ASSOC);

    if (!$withdrawals_setting || $withdrawals_setting['setting_value'] !== '1') {
        http_response_code(403);
        echo json_encode(['success' => false, 'message' => 'Withdrawals are currently disabled']);
        exit;
    }

    $withdrawalRequest->user_id = $data->user_id;
    $withdrawalRequest->amount = $data->amount;
    $withdrawalRequest->payment_type = $data->payment_type;
    $withdrawalRequest->payment_address = $data->payment_address;

    $result = $withdrawalRequest->create();
    echo json_encode($result);
} elseif ($_SERVER['REQUEST_METHOD'] === 'GET') {
    // Get user's withdrawal requests
    if (!isset($_GET['user_id'])) {
        http_response_code(400);
        echo json_encode(['success' => false, 'message' => 'User ID is required']);
        exit;
    }

    $limit = isset($_GET['limit']) ? intval($_GET['limit']) : 10;
    $requests = $withdrawalRequest->getUserRequests($_GET['user_id'], $limit);

    echo json_encode([
        'success' => true,
        'requests' => $requests
    ]);
} else {
    http_response_code(405);
    echo json_encode(['success' => false, 'message' => 'Method not allowed']);
}
